* Section 5:  Distribution of monetary costs and benefits
* Date last edited: 02 October 2018
* File author: Mary-Alice Doyle
clear
set more off


********
* SETUP
********
*cd [specify filepath for working directory]
do ".\Stata files\Regression setup.do"
preserve
drop if ccown==0

* Statement in txt: 30% net cost, 30% break even and  40% net gain
tablecol netdummy idtag if idtag==1 & ccown==1 [pw=w1], colpct nofreq

********
* figure 3 - cumulative distribution
********
* create bins of $20 intervals, output to excel to create graph
egen netbenefitbins = cut(netbenefit1111), at(-22000(20)16000)
quietly: tabout netbenefitbins if idtag==1 [aw=w1] using ".\Excel output\5 descriptives.xls", f(4) c(col) replace
drop netbenefitbins


********
* figure 4 - Net benefit by age-adjusted income quartile
* Note: this definition is different from in the 2017 RDP - quartiles are defined by person, not by transaction
* responents' position in quartile is defined based on full sample, not just on credit card holders
********
restore
gen agehhincq = .

	forval i = 1/5 {
		egen TEMPagehhincq = cut(hhinc) if agebin == `i' & idtag==1, group(4) 
		replace agehhincq = TEMPagehhincq if agehhincq == . 
		drop TEMPagehhincq
	}
	replace agehhincq = agehhincq if agehhincq == .

label define agehhincq 0 "Q1 (0)" 1 "Q2 (1)" 2 "Q3 (2)" 3 "Q4 (3)", replace
label values agehhincq agehhincq

* create new bins variable - this is exactly the same as netdummy variable
egen netbenefitbins = cut(netbenefit1111), at(-22000,-50,50,16000)


tablecol netbenefitbins agehhincq if idtag==1 [pw=w1], colpct nofreq
quietly: tabout netbenefitbins agehhincq if idtag==1 [aw=w1] using ".\Excel output\5 descriptives.xls", f(4) c(col) append clab(agehhincq)

* in-text: 'persists even after excluding respondents who incurred interest charges
tablecol netbenefitbins agehhincq if idtag==1 & q7b!=1 [pw=w1], colpct nofreq

********
* figure 5 - Net benefit by liquid wealth
********

tablecol netbenefitbins deposits if idtag==1 & q3c>=-2 [pw=w1], colpct nofreq
quietly: tabout netbenefitbins deposits if idtag==1 & q3c>=-2 [aw=w1] using ".\Excel output\5 descriptives.xls", f(4) c(col) append clab(deposits)

********
* figure 6 - Net benefit by motivation for choosing card
********

tablecol type netbenefitbins if idtag==1  [pw=w1], rowpct nofreq row
quietly: tabout type netbenefitbins if idtag==1 [aw=w1] using ".\Excel output\5 descriptives.xls", f(4) c(row) append clab(type)

*in-text figures
tablecol type netbenefitbins if idtag==1 & ccown==1 [pw=w1], colpct nofreq col
table type if idtag==1 & ccown==1 [pw=w1], c(median netbenefit1111)
tablecol type q7b if idtag==1 & ccown==1 [pw=w1], rowpct nofreq col row
table type if idtag==1 & q7f>=0 & ccown==1 [pw=w1], c(median q7f)

**********
* Table 1 - net monetary benefit by demographics
**********
tablecol agebin netbenefitbins if idtag==1 [pw=w1], rowpct nofreq
quietly: tabout agebin netbenefitbins if idtag==1 [aw=w1] using ".\Excel output\5 descriptives.xls", f(4) c(row) append clab(age)

tablecol empstatcons netbenefitbins if idtag==1 [pw=w1], rowpct nofreq
quietly: tabout empstatcons netbenefitbins if idtag==1 [aw=w1] using ".\Excel output\5 descriptives.xls", f(4) c(row) append clab(empstat)

tablecol educat2 netbenefitbins if idtag==1 [pw=w1], rowpct nofreq
quietly: tabout educat2 netbenefitbins if idtag==1 [aw=w1] using ".\Excel output\5 descriptives.xls", f(4) c(row) append clab(educat)
